rm(list = ls())
setwd("E:/2024.10.11 诊断医学统计平台/第12-14章 package")







#12.2 LROC Approach
#估计TLR,FPF和ALROC
ALROC <- function(X,Z,c){
  
    # 计算k0和k1
    k0 <- length(X)
    k1 <- nrow(Z)
    
    # 计算TLR(c)
    TLR <- sum(Z[, 1] > c & Z[, 2] == 1) / k1
    
    # 计算FPF(ζ)
    FPF <- sum(X > c) / k0
    
    # 计算ALROC
    ALROC <- 0
    for (j in 1:k1) {
      for (i in 1:k0) {
        Cj <- Z[j, 2]
        Yj <- Z[j, 1]
        Xi <- X[i]
        Psi <- (Yj > Xi) + 0.5 * (Yj == Xi)
        ALROC <- ALROC + Cj * Psi
      }
    }
    ALROC <- ALROC / (k1 * k0)
    
    # 返回结果
    return(list(TLR = TLR, FPF = FPF, ALROC = ALROC))
}

# 示例数据
X <- c(1, 2, 3, 4, 5)
Z <- matrix(c(2, 1, 3, 1, 4, 0, 5, 1), nrow = 4, byrow = TRUE)
c <- 3

# 调用函数并输出结果
result <- ALROC(X, Z, c)
print(result)











#12.2.2 Nonparametric LROC Approach
#计算TLR,FPF,画出对应的分布函数和密度函数
library(ggplot2)

nonparametricTLR_FPF_PLOT <- function(X, Z, c) {
  # 计算k0和k1
  k0 <- length(X)
  k1 <- nrow(Z)
  
  # 定义核函数ϕ(t)和累积分布函数Φ(t)
  phi <- function(t) dnorm(t)
  Phi <- function(t) pnorm(t)
  
  # 计算f_c(ζ)和g(ζ)
  zeta_values <- seq(min(c(X, Z[, 1])) - 3, max(c(X, Z[, 1])) + 3, length.out = 1000)
  f_c <- sapply(zeta_values, function(zeta) {
    sum(Z[, 2] * phi(zeta - Z[, 1])) / k1
  })
  g <- sapply(zeta_values, function(zeta) {
    sum(phi(zeta - X)) / k0
  })
  
  # 绘制f_c(ζ)和g(ζ)的图像
  df_fg <- data.frame(zeta = zeta_values, f_c = f_c, g = g)
  p1 <- ggplot(df_fg, aes(x = zeta)) +
    geom_line(aes(y = f_c, color = "f_c(ζ)")) +
    geom_line(aes(y = g, color = "g(ζ)")) +
    labs(title = "f_c(ζ) and g(ζ)", x = "ζ", y = "Density") +
    scale_color_manual(values = c("f_c(ζ)" = "blue", "g(ζ)" = "red")) +
    theme_minimal()
  print(p1)
  
  # 计算F_c(ζ)和G(ζ)
  F_c <- sapply(zeta_values, function(zeta) {
    sum(Z[, 2] * Phi(zeta - Z[, 1])) / k1
  })
  G <- sapply(zeta_values, function(zeta) {
    sum(Phi(zeta - X)) / k0
  })
  
  # 绘制F_c(ζ)和G(ζ)的图像
  df_FG <- data.frame(zeta = zeta_values, F_c = F_c, G = G)
  p2 <- ggplot(df_FG, aes(x = zeta)) +
    geom_line(aes(y = F_c, color = "F_c(ζ)")) +
    geom_line(aes(y = G, color = "G(ζ)")) +
    labs(title = "F_c(ζ) and G(ζ)", x = "ζ", y = "Cumulative Probability") +
    scale_color_manual(values = c("F_c(ζ)" = "blue", "G(ζ)" = "red")) +
    theme_minimal()
  print(p2)
  
  # 计算TLF(c)
  TLF_c <- integrate(function(y) sapply(y, function(zeta) sum(Z[, 2] * phi(zeta - Z[, 1])) / k1), lower = c, upper = Inf)$value
  
  # 计算FPF(c)
  FPF_c <- 1 - sum(Phi(c - X)) / k0
  
  # 计算ALROC
  ALROC <- 0
  for (j in 1:k1) {
    for (i in 1:k0) {
      Cj <- Z[j, 2]
      Yj <- Z[j, 1]
      Xi <- X[i]
      Psi <- (Yj > Xi) + 0.5 * (Yj == Xi)
      ALROC <- ALROC + Cj * Psi
    }
  }
  ALROC <- ALROC / (k1 * k0)
  
  # 返回结果
  return(list(TLF_c = TLF_c, FPF_c = FPF_c, ALROC = ALROC))
}

# 示例数据
X <- c(1, 2, 3, 4, 5)
Z <- matrix(c(2, 1, 3, 1, 4, 0, 5, 1), nrow = 4, byrow = TRUE)
c <- 3

# 调用函数并输出结果
result <- nonparametricTLR_FPF_PLOT(X, Z, c)
print(result)









#12.2.2
#计算ALROC和其标准差
library(pracma)  # 用于数值积分

nonparametricALROC_sigmaL <- function(X, Z, c) {
  # 计算k0和k1
  k0 <- length(X)
  k1 <- nrow(Z)
  
  # 定义核函数ϕ(t)和累积分布函数Φ(t)
  phi <- function(t) dnorm(t)
  Phi <- function(t) pnorm(t)
  
  # 定义Hϵ(y)函数
  H_epsilon <- function(y) {
    integrate(function(x) phi(x) * Phi(x + y), -Inf, Inf)$value
  }
  
  # 计算ALROC
  ALROC <- 0
  for (j in 1:k1) {
    for (i in 1:k0) {
      Cj <- Z[j, 2]
      Yj <- Z[j, 1]
      Xi <- X[i]
      ALROC <- ALROC + Cj * H_epsilon(Yj - Xi)
    }
  }
  ALROC <- ALROC / (k0 * k1)
  
  # 计算Q
  Q <- sum(Z[, 2]) / k1
  
  # 计算A_c
  A_c <- 0
  for (j in 1:k1) {
    for (i in 1:k0) {
      Cj <- Z[j, 2]
      Yj <- Z[j, 1]
      Xi <- X[i]
      A_c <- A_c + Cj * H_epsilon(Yj - Xi)
    }
  }
  A_c <- A_c / (k0 * k1)
  
  # 计算B_{c11}
  B_c11 <- 0
  for (j in 1:k1) {
    for (i in 1:k0) {
      Cj <- Z[j, 2]
      Yj <- Z[j, 1]
      Xi <- X[i]
      B_c11 <- B_c11 + Cj * H_epsilon(Yj - Xi)^2
    }
  }
  B_c11 <- B_c11 / (k0 * k1)
  
  # 计算B_{c12}
  B_c12 <- 0
  for (j in 1:k1) {
    for (i in 1:k0) {
      for (i_prime in 1:k0) {
        Cj <- Z[j, 2]
        Yj <- Z[j, 1]
        Xi <- X[i]
        Xi_prime <- X[i_prime]
        B_c12 <- B_c12 + Cj * H_epsilon(Yj - Xi) * H_epsilon(Yj - Xi_prime)
      }
    }
  }
  B_c12 <- B_c12 / (k1 * k0^2)
  
  # 计算B_{c21}
  B_c21 <- 0
  for (j in 1:k1) {
    for (i in 1:k0) {
      for (j_prime in 1:k1) {
        Cj <- Z[j, 2]
        Yj <- Z[j, 1]
        Xi <- X[i]
        Yj_prime <- Z[j_prime, 1]
        B_c21 <- B_c21 + Cj * H_epsilon(Yj - Xi) * H_epsilon(Yj_prime - Xi)
      }
    }
  }
  B_c21 <- B_c21 / (k1^2 * k0)
  
  # 计算S_{c0}, S_{c1}, S_{c2}, S_{c3}
  S_c0 <- B_c11 - (1 / Q) * A_c^2
  S_c1 <- B_c12 - (1 / Q) * A_c^2
  S_c2 <- B_c21 - A_c^2
  S_c3 <- (1 - Q) / Q * A_c^2
  
  # 计算σL
  sigmaL <- sqrt((S_c0 + (k0 - 1) * S_c1 + (k1 - 1) * S_c2 + k0 * S_c3) / (k0 * k1))
  
  # 返回结果
  return(list(ALROC = ALROC, sigmaL = sigmaL))
}

# 示例数据
X <- c(1, 2, 3, 4, 5)
Z <- matrix(c(2, 1, 3, 1, 4, 0, 5, 1), nrow = 4, byrow = TRUE)
c <- 3

# 调用函数并输出结果
result <- nonparametricALROC_sigmaL(X, Z, c)
print(result)











#12.3 FROC Approach
library(ggplot2)

calculate_and_plot_FROC_with_AF <- function(t, L, X, n1, Y1, n0, Y0) {
  # 计算k1和k0
  k1 <- length(t)
  k0 <- length(n0)
  
  # 计算T
  T <- sum(t)
  
  # 计算LLF(ζ)和NLF(ζ)
  zeta_values <- sort(unique(c(unlist(X), unlist(Y1), unlist(Y0))))
  LLF <- numeric(length(zeta_values))
  NLF <- numeric(length(zeta_values))
  
  for (i in seq_along(zeta_values)) {
    zeta <- zeta_values[i]
    
    # 计算LLF(ζ)
    LLF[i] <- sum(sapply(1:k1, function(j) sum(L[[j]] == 1 & X[[j]] >= zeta))) / sum(t)
    
    # 计算NLF(ζ)
    NLF[i] <- (sum(sapply(1:k0, function(j) sum(Y0[[j]] >= zeta))) + 
                 sum(sapply(1:k1, function(j) sum(Y1[[j]] >= zeta)))) / (k1 + k0)
  }
  
  # 绘制FROC图像
  df_FROC <- data.frame(NLF = NLF, LLF = LLF)
  p <- ggplot(df_FROC, aes(x = NLF, y = LLF)) +
    geom_line() +
    geom_point() +
    labs(title = "FROC Curve", x = "NLF(ζ)", y = "LLF(ζ)") +
    theme_minimal()
  print(p)
  
  # 计算A_F
  psi <- function(x, y) {
    (x > y) + 0.5 * (x == y)
  }
  
  w1 <- matrix(0, k1, k1)
  w0 <- matrix(0, k0, k0)
  
  for (s_prime in 1:k1) {
    for (s in 1:k1) {
      if (sum(L[[s_prime]]) * n1[s] != 0) {
        w1[s_prime, s] <- sum(sapply(which(L[[s_prime]] == 1), function(i) {
          sum(sapply(1:n1[s], function(j) psi(X[[s_prime]][i], Y1[[s]][j])))
        }))
      }
    }
  }
  
  for (s_prime in 1:k0) {
    for (s in 1:k0) {
      if (sum(L[[s_prime]]) * n0[s] != 0) {
        w0[s_prime, s] <- sum(sapply(which(L[[s_prime]] == 1), function(i) {
          sum(sapply(1:n0[s], function(j) psi(X[[s_prime]][i], Y0[[s]][j])))
        }))
      }
    }
  }
  
  A_F <- (T * (k1 + k0))^(-1) * (sum(w1) + sum(w0))
  
  # 返回结果
  return(list(LLF = LLF, NLF = NLF, A_F = A_F))
}

# 示例数据
t <- c(5, 4, 6, 3, 7)  # 阳性病例的病灶个数
L <- list(
  c(1, 0, 1, 1, 0),
  c(0, 1, 1, 0),
  c(1, 0, 1, 1, 0, 1),
  c(1, 0, 1),
  c(1, 0, 1, 1, 0, 1, 1)
)  # 每个阳性病例的病灶数据
X <- list(
  c(0.8, 0, 0.9, 0.7, 0),
  c(0, 0.7, 0.8, 0),
  c(0.6, 0, 0.8, 0.9, 0, 0.7),
  c(0.8, 0, 0.9),
  c(0.7, 0, 0.8, 0.9, 0, 0.7, 0.8)
)  # 每个阳性病例的置信分数
n1 <- c(3, 2, 4, 1, 5)  # 每个阳性病例的错误定位数
Y1 <- list(
  c(0.5, 0.6, 0.7),
  c(0.7, 0.8),
  c(0.4, 0.5, 0.6, 0.7),
  c(0.8),
  c(0.5, 0.6, 0.7, 0.8, 0.9)
)  # 每个阳性病例的错误定位置信分数
n0 <- c(2, 3, 1, 2, 4)  # 每个阴性病例的错误定位数
Y0 <- list(
  c(0.3, 0.4),
  c(0.4, 0.5, 0.6),
  c(0.3),
  c(0.4, 0.5),
  c(0.3, 0.4, 0.5, 0.6)
)  # 每个阴性病例的错误定位置信分数

# 调用函数并输出结果
result <- calculate_and_plot_FROC_with_AF(t, L, X, n1, Y1, n0, Y0)
print(result)




# 12.3.1.2 Inferred ROC Analysis
library(ggplot2)

calculate_and_plot_iROC_with_AiR <- function(t, L, X, n1, Y1, n0, Y0) {
  # 计算k1和k0
  k1 <- length(t)
  k0 <- length(n0)
  
  # 计算T
  T <- sum(t)
  
  # 计算ϕ1_i
  phi1 <- sapply(1:k1, function(i) ifelse(sum(L[[i]]) != 0 || n1[i] != 0, 1, 0))
  
  # 计算ϕ0_j
  phi0 <- sapply(1:k0, function(j) ifelse(n0[j] != 0, 1, 0))
  
  # 计算z1_i
  z1 <- sapply(1:k1, function(i) {
    if (sum(L[[i]]) != 0 || n1[i] != 0) {
      max(c(X[[i]][L[[i]] == 1], unlist(Y1[[i]])))
    } else {
      -Inf
    }
  })
  
  # 计算z0_j
  z0 <- sapply(1:k0, function(j) {
    if (n0[j] != 0) {
      max(Y0[[j]])
    } else {
      -Inf
    }
  })
  
  # 计算TPF_iR(ζ)和FPF_iR(ζ)
  zeta_values <- sort(unique(c(z1, z0)))
  TPF_iR <- numeric(length(zeta_values))
  FPF_iR <- numeric(length(zeta_values))
  
  for (i in seq_along(zeta_values)) {
    zeta <- zeta_values[i]
    
    # 计算TPF_iR(ζ)
    TPF_iR[i] <- sum(phi1 == 1 & z1 >= zeta) / k1
    
    # 计算FPF_iR(ζ)
    FPF_iR[i] <- sum(phi0 == 1 & z0 >= zeta) / k0
  }
  
  # 确保FPF_iR和TPF_iR的对应关系是单调增加的
  df_iROC <- data.frame(FPF_iR = FPF_iR, TPF_iR = TPF_iR)
  df_iROC <- df_iROC[order(df_iROC$FPF_iR, df_iROC$TPF_iR), ]
  
  # 绘制iROC曲线
  p <- ggplot(df_iROC, aes(x = FPF_iR, y = TPF_iR)) +
    geom_line() +
    geom_point() +
    annotate("segment", x = 0, y = 0, xend = min(df_iROC$FPF_iR), yend = 0, linetype = "dashed", color = "blue") +
    annotate("segment", x = max(df_iROC$FPF_iR), y = max(df_iROC$TPF_iR), xend = 1, yend = 1, linetype = "dashed", color = "red") +
    labs(title = "iROC Curve", x = "FPF_iR(ζ)", y = "TPF_iR(ζ)") +
    xlim(0, 1) +
    ylim(0, 1) +
    theme_minimal()
  print(p)
  
  # 计算A_iR
  psi <- function(x, y) {
    (x > y) + 0.5 * (x == y)
  }
  
  w <- matrix(0, k1, k0)
  
  for (s_prime in 1:k1) {
    for (s in 1:k0) {
      if (phi1[s_prime] == 1 && phi0[s] == 1) {
        w[s_prime, s] <- psi(z1[s_prime], z0[s])
      } else if (phi1[s_prime] == 1 && phi0[s] == 0) {
        w[s_prime, s] <- 1
      } else if (phi1[s_prime] == 0 && phi0[s] == 0) {
        w[s_prime, s] <- 0.5
      } else if (phi1[s_prime] == 0 && phi0[s] == 1) {
        w[s_prime, s] <- 0
      }
    }
  }
  
  A_iR <- sum(w) / (k1 * k0)
  
  # 返回结果
  return(list(TPF_iR = df_iROC$TPF_iR, FPF_iR = df_iROC$FPF_iR, A_iR = A_iR))
}

# 示例数据
t <- c(3, 2, 3, 1, 3, 2, 3, 1, 2, 3, 3, 2, 3, 1, 3, 2, 3, 1, 2, 3)  # 阳性病例的病灶个数，每个不超过3个
L <- list(
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(0, 1),
  c(1, 0, 1),
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(0, 1),
  c(1, 0, 1)
)  # 每个阳性病例的病灶数据
X <- list(
  c(0.8, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0.7, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0, 0.7),
  c(0.7, 0, 0.9),
  c(0.8, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0.7, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0, 0.7),
  c(0.7, 0, 0.9)
)  # 每个阳性病例的置信分数
n1 <- c(2, 0, 2, 0, 2, 0, 2, 0, 0, 2, 2, 0, 2, 0, 2, 0, 2, 0, 0, 2)  # 每个阳性病例的错误定位数，多取一些为0
Y1 <- list(
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  numeric(0),
  c(0.5, 0.6),
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  numeric(0),
  c(0.5, 0.6)
)  # 每个阳性病例的错误定位置信分数
n0 <- c(2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2)  # 每个阴性病例的错误定位数
Y0 <- list(
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3),
  c(0.3, 0.4),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3),
  c(0.3, 0.4)
)  # 每个阴性病例的错误定位置信分数

# 调用函数并输出结果
result <- calculate_and_plot_iROC_with_AiR(t, L, X, n1, Y1, n0, Y0)
print(result)











#12.3.1.3 AFROC Curve
library(ggplot2)

calculate_and_plot_AFROC_with_AAF <- function(t, L, X, n1, Y1, n0, Y0) {
  # 计算k1和k0
  k1 <- length(t)
  k0 <- length(n0)
  
  # 计算T
  T <- sum(t)
  
  # 计算ϕ0_j
  phi0 <- sapply(1:k0, function(j) ifelse(n0[j] != 0, 1, 0))
  
  # 计算z0_j
  z0 <- sapply(1:k0, function(j) {
    if (n0[j] != 0) {
      max(Y0[[j]])
    } else {
      -Inf
    }
  })
  
  # 计算LLFA(ζ)和FPFA(ζ)
  zeta_values <- sort(unique(c(unlist(X), z0)))
  LLFA <- numeric(length(zeta_values))
  FPFA <- numeric(length(zeta_values))
  
  for (i in seq_along(zeta_values)) {
    zeta <- zeta_values[i]
    
    # 计算LLFA(ζ)
    LLFA[i] <- sum(sapply(1:k1, function(j) sum(L[[j]] == 1 & X[[j]] >= zeta))) / sum(t)
    
    # 计算FPFA(ζ)
    FPFA[i] <- sum(phi0 == 1 & z0 >= zeta) / k0
  }
  
  # 确保FPFA和LLFA的对应关系是单调增加的
  df_AFROC <- data.frame(FPFA = FPFA, LLFA = LLFA)
  df_AFROC <- df_AFROC[order(df_AFROC$FPFA, df_AFROC$LLFA), ]
  
  # 绘制AFROC图像
  p <- ggplot(df_AFROC, aes(x = FPFA, y = LLFA)) +
    geom_line() +
    geom_point() +
    labs(title = "AFROC Curve", x = "FPFA(ζ)", y = "LLFA(ζ)") +
    xlim(0, 1) +
    ylim(0, 1) +
    theme_minimal()
  print(p)
  
  # 计算AAF
  psi <- function(x, y) {
    (x > y) + 0.5 * (x == y)
  }
  
  wA <- matrix(0, k1, k0)
  
  for (s_prime in 1:k1) {
    for (s in 1:k0) {
      if (sum(L[[s_prime]]) != 0 && phi0[s] == 1) {
        wA[s_prime, s] <- sum(sapply(which(L[[s_prime]] == 1), function(r) psi(X[[s_prime]][r], z0[s])))
      } else if (sum(L[[s_prime]]) != 0 && phi0[s] == 0) {
        wA[s_prime, s] <- (t[s_prime] - sum(L[[s_prime]])) / 2
      } else if (sum(L[[s_prime]]) == 0 && phi0[s] == 0) {
        wA[s_prime, s] <- t[s_prime] / 2
      } else if (sum(L[[s_prime]]) == 0 && phi0[s] == 1) {
        wA[s_prime, s] <- 0
      }
    }
  }
  
  AAF <- sum(wA) / (T * k0)
  
  # 返回结果
  return(list(LLFA = df_AFROC$LLFA, FPFA = df_AFROC$FPFA, AAF = AAF))
}

# 示例数据
t <- c(3, 2, 3, 1, 3, 2, 3, 1, 2, 3, 3, 2, 3, 1, 3, 2, 3, 1, 2, 3)  # 阳性病例的病灶个数，每个不超过3个
L <- list(
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(0, 1),
  c(1, 0, 1),
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(1, 0, 1),
  c(0, 1),
  c(1, 0, 1),
  c(1),
  c(0, 1),
  c(1, 0, 1)
)  # 每个阳性病例的病灶数据
X <- list(
  c(0.8, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0.7, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0, 0.7),
  c(0.7, 0, 0.9),
  c(0.8, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0.7, 0, 0.9),
  c(0, 0.7),
  c(0.6, 0, 0.8),
  c(0.8),
  c(0, 0.7),
  c(0.7, 0, 0.9)
)  # 每个阳性病例的置信分数
n1 <- c(2, 0, 2, 0, 2, 0, 2, 0, 0, 2, 2, 0, 2, 0, 2, 0, 2, 0, 0, 2)  # 每个阳性病例的错误定位数，多取一些为0
Y1 <- list(
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  numeric(0),
  c(0.5, 0.6),
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  c(0.5, 0.6),
  numeric(0),
  c(0.4, 0.5),
  numeric(0),
  numeric(0),
  c(0.5, 0.6)
)  # 每个阳性病例的错误定位置信分数
n0 <- c(2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2)  # 每个阴性病例的错误定位数
Y0 <- list(
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3),
  c(0.3, 0.4),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3, 0.4),
  c(0.3),
  c(0.3),
  c(0.3, 0.4)
)  # 每个阴性病例的错误定位置信分数

# 调用函数并输出结果
result <- calculate_and_plot_AFROC_with_AAF(t, L, X, n1, Y1, n0, Y0)
print(result)





#12.3.3 Resampling Methods
calculate_FAUC_with_SD <- function(t, L, X, n1, Y1, n0, Y0, p = NULL) {
  # 计算k1和k0
  k1 <- length(t)
  k0 <- length(n0)
  
  # 计算T
  T <- sum(t)
  
  # 计算ϕ1_i
  phi1 <- sapply(1:k1, function(i) ifelse(sum(L[[i]]) != 0 || n1[i] != 0, 1, 0))
  
  # 计算ϕ0_j
  phi0 <- sapply(1:k0, function(j) ifelse(n0[j] != 0, 1, 0))
  
  # 计算z1_i
  z1 <- sapply(1:k1, function(i) {
    if (!is.na(sum(L[[i]])) && sum(L[[i]]) != 0 || !is.na(n1[i]) && n1[i] != 0) {
      max(c(X[[i]][L[[i]] == 1], unlist(Y1[[i]])))
    } else {
      -Inf
    }
  })
  
  # 计算z0_j
  z0 <- sapply(1:k0, function(j) {
    if (!is.na(n0[j]) && n0[j] != 0) {
      max(Y0[[j]])
    } else {
      -Inf
    }
  })
  
  # 计算LLF(ζ)和NLF(ζ)
  zeta_values <- sort(unique(c(unlist(X), unlist(Y1), unlist(Y0))))
  LLF <- numeric(length(zeta_values))
  NLF <- numeric(length(zeta_values))
  
  for (i in seq_along(zeta_values)) {
    zeta <- zeta_values[i]
    
    # 计算LLF(ζ)
    LLF[i] <- sum(sapply(1:k1, function(j) sum(L[[j]] == 1 & X[[j]] >= zeta))) / sum(t)
    
    # 计算NLF(ζ)
    NLF[i] <- (sum(sapply(1:k0, function(j) sum(Y0[[j]] >= zeta))) + 
                 sum(sapply(1:k1, function(j) sum(Y1[[j]] >= zeta)))) / (k1 + k0)
  }
  
  # 确保NLF和LLF的对应关系是单调增加的
  df_FROC <- data.frame(NLF = NLF, LLF = LLF)
  df_FROC <- df_FROC[order(df_FROC$NLF, df_FROC$LLF), ]
  
  # 计算FAUC
  FAUC <- sum(diff(df_FROC$NLF) * (df_FROC$LLF[-1] + df_FROC$LLF[-nrow(df_FROC)]) / 2)
  
  # Jackknife方法计算FAUC的标准差
  jackknife_FAUC <- numeric(k1 + k0)
  
  for (i in 1:k1) {
    # 删除第i个阳性病例
    t_jack <- t[-i]
    L_jack <- L[-i]
    X_jack <- X[-i]
    n1_jack <- n1[-i]
    Y1_jack <- Y1[-i]
    
    jackknife_FAUC[i] <- calculate_FAUC(t_jack, L_jack, X_jack, n1_jack, Y1_jack, n0, Y0)
  }
  
  for (j in 1:k0) {
    # 删除第j个阴性病例
    n0_jack <- n0[-j]
    Y0_jack <- Y0[-j]
    
    jackknife_FAUC[k1 + j] <- calculate_FAUC(t, L, X, n1, Y1, n0_jack, Y0_jack)
  }
  
  jackknife_FAUC_mean <- mean(jackknife_FAUC)
  jackknife_FAUC_var <- ((k1 + k0 - 1) / (k1 + k0)) * sum((jackknife_FAUC - jackknife_FAUC_mean)^2)
  jackknife_FAUC_sd <- sqrt(jackknife_FAUC_var)
  
  # Bootstrap方法计算FAUC的标准差
  if (!is.null(p)) {
    bootstrap_FAUC <- numeric(p)
    
    for (b in 1:p) {
      # 从阳性样本中抽取大于一半的样本
      k1_boot <- sample(1:k1, ceiling(k1 / 2) + 1, replace = TRUE)
      t_boot <- t[k1_boot]
      L_boot <- L[k1_boot]
      X_boot <- X[k1_boot]
      n1_boot <- n1[k1_boot]
      Y1_boot <- Y1[k1_boot]
      
      # 从阴性样本中抽取大于一半的样本
      k0_boot <- sample(1:k0, ceiling(k0 / 2) + 1, replace = TRUE)
      n0_boot <- n0[k0_boot]
      Y0_boot <- Y0[k0_boot]
      
      bootstrap_FAUC[b] <- calculate_FAUC(t_boot, L_boot, X_boot, n1_boot, Y1_boot, n0_boot, Y0_boot)
    }
    
    bootstrap_FAUC_mean <- mean(bootstrap_FAUC)
    bootstrap_FAUC_var <- var(bootstrap_FAUC)
    bootstrap_FAUC_sd <- sqrt(bootstrap_FAUC_var)
  } else {
    bootstrap_FAUC_sd <- NA
  }
  
  # 返回结果
  return(list(FAUC = FAUC, 
              jackknife_FAUC_sd = jackknife_FAUC_sd, bootstrap_FAUC_sd = bootstrap_FAUC_sd))
}

# 辅助函数：计算FAUC
calculate_FAUC <- function(t, L, X, n1, Y1, n0, Y0) {
  k1 <- length(t)
  k0 <- length(n0)
  T <- sum(t)
  
  phi1 <- sapply(1:k1, function(i) ifelse(sum(L[[i]]) != 0 || n1[i] != 0, 1, 0))
  phi0 <- sapply(1:k0, function(j) ifelse(n0[j] != 0, 1, 0))
  
  z1 <- sapply(1:k1, function(i) {
    if (!is.na(sum(L[[i]])) && sum(L[[i]]) != 0 || !is.na(n1[i]) && n1[i] != 0) {
      max(c(X[[i]][L[[i]] == 1], unlist(Y1[[i]])))
    } else {
      -Inf
    }
  })
  
  z0 <- sapply(1:k0, function(j) {
    if (!is.na(n0[j]) && n0[j] != 0) {
      max(Y0[[j]])
    } else {
      -Inf
    }
  })
  
  zeta_values <- sort(unique(c(unlist(X), unlist(Y1), unlist(Y0))))
  LLF <- numeric(length(zeta_values))
  NLF <- numeric(length(zeta_values))
  
  for (i in seq_along(zeta_values)) {
    zeta <- zeta_values[i]
    
    LLF[i] <- sum(sapply(1:k1, function(j) sum(L[[j]] == 1 & X[[j]] >= zeta))) / sum(t)
    NLF[i] <- (sum(sapply(1:k0, function(j) sum(Y0[[j]] >= zeta))) + 
                 sum(sapply(1:k1, function(j) sum(Y1[[j]] >= zeta)))) / (k1 + k0)
  }
  
  df_FROC <- data.frame(NLF = NLF, LLF = LLF)
  df_FROC <- df_FROC[order(df_FROC$NLF, df_FROC$LLF), ]
  
  FAUC <- sum(diff(df_FROC$NLF) * (df_FROC$LLF[-1] + df_FROC$LLF[-nrow(df_FROC)]) / 2)
  
  return(FAUC)
}

# 示例数据
t <- c(5, 4, 6, 3, 7)  # 阳性病例的病灶个数
L <- list(
  c(1, 0, 1, 1, 0),
  c(0, 1, 1, 0),
  c(1, 0, 1, 1, 0, 1),
  c(1, 0, 1),
  c(1, 0, 1, 1, 0, 1, 1)
)  # 每个阳性病例的病灶数据
X <- list(
  c(0.8, 0, 0.9, 0.7, 0),
  c(0, 0.7, 0.8, 0),
  c(0.6, 0, 0.8, 0.9, 0, 0.7),
  c(0.8, 0, 0.9),
  c(0.7, 0, 0.8, 0.9, 0, 0.7, 0.8)
)  # 每个阳性病例的置信分数
n1 <- c(3, 2, 4, 1, 5)  # 每个阳性病例的错误定位数
Y1 <- list(
  c(0.5, 0.6, 0.7),
  c(0.7, 0.8),
  c(0.4, 0.5, 0.6, 0.7),
  c(0.8),
  c(0.5, 0.6, 0.7, 0.8, 0.9)
)  # 每个阳性病例的错误定位置信分数
n0 <- c(2, 3, 1, 2, 4)  # 每个阴性病例的错误定位数
Y0 <- list(
  c(0.3, 0.4),
  c(0.4, 0.5, 0.6),
  c(0.3),
  c(0.4, 0.5),
  c(0.3, 0.4, 0.5, 0.6)
)  # 每个阴性病例的错误定位置信分数

# 调用函数并输出结果
result <- calculate_FAUC_with_SD(t, L, X, n1, Y1, n0, Y0, p = 1000)
print(result)














#12.4 ROI Approach 12.4.1 Nonparametric ROI Analysis Method
library(ggplot2)

# 定义函数来处理数据输入并计算TPF(ζ)、FPF(ζ)和AROI
calculate_and_plot_ROI <- function(y, x) {
  # 计算总样本数S
  S <- length(y)
  
  # 计算每个样本的ROI总数t_i
  t <- sapply(1:S, function(i) length(y[[i]]) + length(x[[i]]))
  
  # 计算总感染ROIs和非感染ROIs的数量
  m <- sapply(y, length)
  n <- sapply(x, length)
  
  # 计算M和N
  M <- sum(m)
  N <- sum(n)
  
  # 计算TPF(ζ)和FPF(ζ)
  zeta_values <- sort(unique(c(unlist(y), unlist(x))))
  TPF <- numeric(length(zeta_values))
  FPF <- numeric(length(zeta_values))
  
  for (i in seq_along(zeta_values)) {
    zeta <- zeta_values[i]
    
    # 计算TPF(ζ)
    TPF[i] <- sum(sapply(1:S, function(j) sum(y[[j]] > zeta))) / M
    
    # 计算FPF(ζ)
    FPF[i] <- sum(sapply(1:S, function(j) sum(x[[j]] > zeta))) / N
  }
  
  # 确保FPF和TPF的对应关系是单调增加的
  df_ROI <- data.frame(FPF = FPF, TPF = TPF)
  df_ROI <- df_ROI[order(df_ROI$FPF, df_ROI$TPF), ]
  
  # 绘制ROI曲线
  p <- ggplot(df_ROI, aes(x = FPF, y = TPF)) +
    geom_line() +
    geom_point() +
    labs(title = "ROI Curve", x = "FPF(ζ)", y = "TPF(ζ)") +
    xlim(0, 1) +
    ylim(0, 1) +
    theme_minimal()
  print(p)
  
  # 计算AROI
  psi <- function(x, y) {
    (x > y) + 0.5 * (x == y)
  }
  
  AROI <- 0
  for (i in 1:S) {
    for (j in 1:m[i]) {
      for (s in 1:S) {
        for (k in 1:n[s]) {
          AROI <- AROI + psi(y[[i]][j], x[[s]][k])
        }
      }
    }
  }
  AROI <- AROI / (M * N)
  
  # 返回结果
  return(list(TPF = df_ROI$TPF, FPF = df_ROI$FPF, AROI = AROI))
}

# 示例数据
y <- list(
  c(0.8, 0.9, 0.7),  # 第1个样本的感染ROI评分
  c(0.7, 0.8, 0.9),  # 第2个样本的感染ROI评分
  c(0.6, 0.8, 0.9, 0.7)  # 第3个样本的感染ROI评分
)
x <- list(
  c(0.3, 0.4),  # 第1个样本的非感染ROI评分
  c(0.4, 0.5, 0.6),  # 第2个样本的非感染ROI评分
  c(0.3, 0.4, 0.5, 0.6)  # 第3个样本的非感染ROI评分
)

# 调用函数并输出结果
result <- calculate_and_plot_ROI(y, x)
print(result)







#12.4.2 iROI Paradigm



